#!/bin/bash
MODEL_PATH=$1
set -e # exit on error
pred_file=${MODEL_PATH}/unk_vqa_validated/merge.jsonl

python inf_qwen_vl.py eval \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/vqav2/vqa_k_test_noun_dedup_sampled_1_sft_llaval_idk.human_valid_rewrite.eval.jsonl \
        --image-folder <DATA_FOLDER>/lama-gpt4v_gen_q/ \
        --answer-file ${pred_file}


output_file=${MODEL_PATH}/unk_vqa_validated/pred_probs_only_yes_or_no/merge.jsonl
python inf_qwen_vl.py get_pred_prob_only_yes_or_no \
        --model-path ${MODEL_PATH} \
        --question-file <DATA_FOLDER>/vqav2/vqa_k_test_noun_dedup_sampled_1_sft_llaval_idk.human_valid_rewrite.eval.jsonl \
        --image-folder <DATA_FOLDER>/lama-gpt4v_gen_q/ \
        --pred_file ${pred_file} \
        --answer-file ${output_file} \
        --overwrite 

